<?php

/**
 * Class that operate on table 'billname'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class BillnameMySqlDAO implements BillnameDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return BillnameMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM billname WHERE billnameid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM billname';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM billname ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param billname primary key
     */
    public function delete($billnameid) {
        $sql = 'DELETE FROM billname WHERE billnameid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($billnameid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param BillnameMySql billname
     */
    public function insert($billname) {
        $sql = 'INSERT INTO billname (name, userid, conditions, billnamedate, billtype, billtype2,ordertype,saveeffect,productAndQuantityOnly,posFlag,posCode,posType,posWeightPrice,checkDigit,goodsReceiptApproval,parcodeType,defVisaAccount,defVisaAccountSelect,isBankAccountTransfer,taxOfDiscountVal,taxOfDiscountPrint,extraDiscountPlace,extraDiscountFixed,extraDiscountPer,storeeffect,taxname) VALUES (?, ?, ?, ?, ? ,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($billname->name);
        $sqlQuery->setNumber($billname->userid);
        $sqlQuery->setNumber($billname->conditions);
        $sqlQuery->set($billname->billnamedate);
        $sqlQuery->setNumber($billname->billtype);
        $sqlQuery->setNumber($billname->billtype2);

        $sqlQuery->setNumber($billname->ordertype);
        $sqlQuery->setNumber($billname->saveeffect);

        $sqlQuery->setNumber($billname->productAndQuantityOnly);

        $sqlQuery->setNumber($billname->posFlag);
        $sqlQuery->setNumber($billname->posCode);
        $sqlQuery->setNumber($billname->posType);
        $sqlQuery->setNumber($billname->posWeightPrice);
        $sqlQuery->setNumber($billname->checkDigit);
        $sqlQuery->set($billname->goodsReceiptApproval);
        $sqlQuery->setNumber((int) $billname->parcodeType);
        $sqlQuery->setNumber((int) $billname->defVisaAccount);
        $sqlQuery->setNumber((int) $billname->defVisaAccountSelect);
        $sqlQuery->setNumber((int) $billname->isBankAccountTransfer);
        $sqlQuery->setNumber((float) $billname->taxOfDiscountVal);
        $sqlQuery->setNumber((int) $billname->taxOfDiscountPrint);
        $sqlQuery->setNumber((int) $billname->extraDiscountPlace);
        $sqlQuery->setNumber((int) $billname->extraDiscountFixed);
        $sqlQuery->setNumber((float) $billname->extraDiscountPer);
        $sqlQuery->setNumber((float) $billname->storeeffect);
        $sqlQuery->set($billname->taxname);

        $id = $this->executeInsert($sqlQuery);
        $billname->billnameid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param BillnameMySql billname
     */
    public function update($billname) {
        $sql = 'UPDATE billname SET name = ?, userid = ?, conditions = ?, billnamedate = ?, billtype = ? , billtype2 = ? ,ordertype = ? ,saveeffect = ?,productAndQuantityOnly = ? ,posFlag = ?,posCode = ?,posType = ?,posWeightPrice = ?,checkDigit = ?,goodsReceiptApproval = ?,parcodeType = ?,defVisaAccount = ?,defVisaAccountSelect = ?,isBankAccountTransfer = ?,taxOfDiscountVal=?,taxOfDiscountPrint=?,extraDiscountPlace=?,extraDiscountFixed = ?,extraDiscountPer=?,storeeffect=?,taxname=?  WHERE billnameid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($billname->name);
        $sqlQuery->setNumber($billname->userid);
        $sqlQuery->setNumber($billname->conditions);
        $sqlQuery->set($billname->billnamedate);
        $sqlQuery->setNumber($billname->billtype);

        $sqlQuery->setNumber($billname->billtype2);
        $sqlQuery->setNumber($billname->ordertype);
        $sqlQuery->setNumber($billname->saveeffect);
        $sqlQuery->setNumber($billname->productAndQuantityOnly);
        $sqlQuery->setNumber($billname->posFlag);
        $sqlQuery->setNumber($billname->posCode);
        $sqlQuery->setNumber($billname->posType);
        $sqlQuery->setNumber($billname->posWeightPrice);
        $sqlQuery->setNumber($billname->checkDigit);
        $sqlQuery->set($billname->goodsReceiptApproval);
        $sqlQuery->setNumber((int) $billname->parcodeType);
        $sqlQuery->setNumber((int) $billname->defVisaAccount);
        $sqlQuery->setNumber((int) $billname->defVisaAccountSelect);
        $sqlQuery->setNumber((int) $billname->isBankAccountTransfer);
        $sqlQuery->setNumber((float) $billname->taxOfDiscountVal);
        $sqlQuery->setNumber((int) $billname->taxOfDiscountPrint);
        $sqlQuery->setNumber((int) $billname->extraDiscountPlace);
        $sqlQuery->setNumber((int) $billname->extraDiscountFixed);
        $sqlQuery->setNumber((float) $billname->extraDiscountPer);
        $sqlQuery->setNumber((float) $billname->storeeffect);
        $sqlQuery->set($billname->taxname);

        $sqlQuery->setNumber($billname->billnameid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM billname';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByName($value) {
        $sql = 'SELECT * FROM billname WHERE name = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM billname WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCondition($value) {
        $sql = 'SELECT * FROM billname WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBillnamedate($value) {
        $sql = 'SELECT * FROM billname WHERE billnamedate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByName($value) {
        $sql = 'DELETE FROM billname WHERE name = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM billname WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCondition($value) {
        $sql = 'DELETE FROM billname WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBillnamedate($value) {
        $sql = 'DELETE FROM billname WHERE billnamedate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return BillnameMySql
     */
    protected function readRow($row) {
        $billname = new Billname();

        $billname->billnameid = isset($row['billnameid']) ? $row['billnameid'] : '';
        $billname->name = isset($row['name']) ? $row['name'] : '';
        $billname->userid = isset($row['userid']) ? $row['userid'] : '';
        $billname->conditions = isset($row['conditions']) ? $row['conditions'] : '';
        $billname->billnamedate = isset($row['billnamedate']) ? $row['billnamedate'] : '';
        $billname->billtype = isset($row['billtype']) ? $row['billtype'] : '';
        $billname->billtype2 = isset($row['billtype2']) ? $row['billtype2'] : '';

        $billname->ordertype = isset($row['ordertype']) ? $row['ordertype'] : '';
        $billname->saveeffect = isset($row['saveeffect']) ? $row['saveeffect'] : '';
        $billname->productAndQuantityOnly = isset($row['productAndQuantityOnly']) ? $row['productAndQuantityOnly'] : '';

        $billname->posFlag = isset($row['posFlag']) ? $row['posFlag'] : '';
        $billname->posCode = isset($row['posCode']) ? $row['posCode'] : '';
        $billname->posType = isset($row['posType']) ? $row['posType'] : '';
        $billname->posWeightPrice = isset($row['posWeightPrice']) ? $row['posWeightPrice'] : '';
        $billname->checkDigit = isset($row['checkDigit']) ? $row['checkDigit'] : '';
        $billname->goodsReceiptApproval = isset($row['goodsReceiptApproval']) ? $row['goodsReceiptApproval'] : '';
        $billname->parcodeType = isset($row['parcodeType']) ? $row['parcodeType'] : '';
        $billname->defVisaAccount = isset($row['defVisaAccount']) ? $row['defVisaAccount'] : '';
        $billname->defVisaAccountSelect = isset($row['defVisaAccountSelect']) ? $row['defVisaAccountSelect'] : '';
        $billname->isBankAccountTransfer = isset($row['isBankAccountTransfer']) ? $row['isBankAccountTransfer'] : '';
        $billname->taxOfDiscountVal = isset($row['taxOfDiscountVal']) ? $row['taxOfDiscountVal'] : '';
        $billname->taxOfDiscountPrint = isset($row['taxOfDiscountPrint']) ? $row['taxOfDiscountPrint'] : '';
        $billname->extraDiscountPlace = isset($row['extraDiscountPlace']) ? $row['extraDiscountPlace'] : '';
        $billname->extraDiscountFixed = isset($row['extraDiscountFixed']) ? $row['extraDiscountFixed'] : '';
        $billname->extraDiscountPer = isset($row['extraDiscountPer']) ? $row['extraDiscountPer'] : '';
        $billname->storeeffect = isset($row['storeeffect']) ? $row['storeeffect'] : '';
        $billname->taxname = isset($row['taxname']) ? $row['taxname'] : '';

        return $billname;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return BillnameMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>